import numpy as np
import torch
def get_trajectories(optimizers, func, num_iterations, compression_ratio):
    trajectories = {}
    for optimizer in optimizers:
        # 初始化可训练参数
        params = [param for group in optimizer.param_groups for param in group['params']]

        trajectory = []

        # 优化过程
        for i in range(num_iterations):  
            optimizer.zero_grad()  # 清除梯度
            loss = func(params[0], params[1])  # 计算函数值
            if i % compression_ratio == 0:  # 每compression_ratio步采样一次
                trajectory.append(np.array([params[0].item(), params[1].item(), loss.item()]))  # 记录轨迹
            loss.backward()  # 反向传播
            # 为梯度添加噪音
            # noise_std = 0.1  # 噪音标准差
            # for group in optimizer.param_groups:
            #     for param in group['params']:
            #         if param.grad is not None:
            #             noise = torch.normal(mean=0, std=noise_std, size=param.grad.shape)
            #             param.grad += noise
            optimizer.step()  # 更新参数
        
        trajectories[optimizer.__class__.__name__] = np.array(trajectory).T
    return trajectories